/*!
        @file    $Id:: gaugeConfig.h #$

        @brief

        @author  Hideo Matsufuru <hideo.matsufuru@kek.jp> (matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-22 16:55:30 #$

        @version $LastChangedRevision: 943 $
*/


#ifndef GAUGECONFIG_INCLUDED
#define GAUGECONFIG_INCLUDED

#include <string>
using std::string;

#include "defs.h"
#include "configure.h"
#include "commonParameters.h"
#include "field.h"
#include "field_G.h"
#include "fieldIO.h"
#include "bridgeIO.h"
using Bridge::vout;

//! GaugeConfig class for file I/O of gauge configuration.

/*!
   This class family is used to setup and output the gauge
   configuration.
   This is the base class, which implements common functions,
   and read/write methods are implemented in subclasses.
   At present, cutting off the gauge field for each node
   and deliver it to the node is implemented in this class.
   It may be better to separate that to other class for
   general usage for other field objects.
                                [28 Dec 2011 H.Matsufuru]

   GaugeConfig class provides file I/O of gauge configuration.
   It provides an interface to underlying FieldIO class family;

   The file format is specified by a string argument type to
   the constructor (in a somewhat similar manner as factory).
   Data layout is ILDG layout for most of the cases except
   for Fortran_JLQCD in which JLQCD layout is applied.

   Filename may be generated from configuration number with
   prefix and postfix specified by set_prefix/set_postfix methods
   or set_parameters. i.e. prefix + %06d + postfix .
 */

class GaugeConfig
{
 public:
  GaugeConfig(const string& type);
  virtual ~GaugeConfig();

  static void set_cold(Field *U);  //!< cold start. set all links to unity.

  void read_file(Field *u, const string& filename);
  void write_file(Field *u, const string& filename);

  void read_config(Field *U, int confnum);
  void write_config(Field *U, int confnum);

  void set_prefix(string prefix)
  {
    m_prefix = prefix;
  }

  void set_postfix(string postfix)
  {
    m_postfix = postfix;
  }

  void set_parameters(const string& prefix, const string& postfix)
  {
    set_prefix(prefix);
    set_postfix(postfix);
  }

 private:
  string config_filename(const int);

  // not copyable.
  GaugeConfig(const GaugeConfig&) {}
  GaugeConfig& operator=(const GaugeConfig&);

 protected:
  string               m_prefix, m_postfix;
  Bridge::VerboseLevel m_vl;
  FieldIO              *m_fieldio;
};
#endif
