/*!
        @file    $Id:: gaugeConfig_SF.h 93#$

        @brief

        @author  Yusuke Taniguchi <tanigchi@het.ph.tsukuba.ac.jp>
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef GAUGECONFIG_SF_INCLUDED
#define GAUGECONFIG_SF_INCLUDED

#include <string>
using std::string;

#include "gaugeConfig.h"
#include "index_lex.h"
#include "field.h"
#include "field_G.h"

/*!
  Setup the tree level gauge configuration for the SF boundary condition, which minimize the classical action.
  \f[
  U_3=1
  \f]
  \f[
  U_k(x)=\exp\left(aB_k(x)\right),\quad
  B_k(x)=\frac{1}{T}\left(x_0C_k'+(T-x_0)C_k\right)
  \f]
  \f[
  C_k=\frac{i}{L}\pmatrix{\phi_1\cr&\phi_2\cr&&\phi_3\cr},\quad
  C_k'=\frac{i}{L}\pmatrix{\phi'_1\cr&\phi'_2\cr&&\phi'_3\cr}
  \f]
 */
class GaugeConfig_SF : public GaugeConfig
{
 public:
  GaugeConfig_SF(const string& type) : GaugeConfig(type) {}

  void set_cold_SF(Field *U, double *phi, double *phipr);
};
#endif
