/*!
        @file    $Id:: io_format_gaug#$

        @brief

        @author  Tatsumi Aoyama <aoym@post.kek.jp> (aoym)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-22 16:55:30 #$

        @version $LastChangedRevision: 943 $
*/
#ifndef IO_FORMAT_GAUGE_INCLUDED
#define IO_FORMAT_GAUGE_INCLUDED

#include "io_format.h"
#include "commonParameters.h"

namespace IO_Format {
  namespace Gauge {
/**
  ILDG_Format -- 4-dimensional SU(3) gauge field configuration

  layout: (u_\mu(n))_ab
    complex x b x a x mu x n
*/

    class ILDG_Format : public Format {
     public:
      ILDG_Format()
      {
//    int nc = CommonParameters::Nc();
//    int ndim = CommonParameters::Ndim();

        int nc   = 3;
        int ndim = 4;

        m_nin    = 2 * nc * nc * ndim;
        m_nex    = 1;
        m_matrix = 2 * nc * nc;
      }

      int nin() const { return m_nin; }
      int nex() const { return m_nex; }

      void file_to_field(int& s, int& t, const int i, const int j) const
      {
        s = i % m_matrix;
        t = i / m_matrix;
      }

     private:
      int m_nin;
      int m_nex;
      int m_matrix;
    };

/**
  JLQCD_Format -- JLQCD gauge configuration

  layout: (u_\mu(n))_ab
    complex x b x a x site x mu

  (same as present Field_G format. thus adopt Trivial_Format class.)
 */


    class JLQCD_Format : public Trivial_Format {};


#if 0
    class JLQCD_Format : public Format {
     public:
      JLQCD_Format()
      {
        int nc   = CommonParameters::Nc();
        int ndim = CommonParameters::Ndim();

        m_nin    = 2 * nc * nc;
        m_nex    = ndim;
        m_matrix = 2 * nc * nc;
      }

      int nin() const { return m_nin; }
      int nex() const { return m_nex; }

      void file_to_field(int& s, int& t, const int i, const int j) const
      {
        s = i;
        t = j;
      }

     private:
      int m_nin;
      int m_nex;
      int m_matrix;
    };
#endif

//----------------------------------------------------------------
// predefined formats

    extern const Format *ILDG;
    extern const Format *JLQCD;
  } // namespace Gauge
}   // namespace IO_Format
#endif /* IO_FORMAT_GAUGE_INCLUDED */
