#ifndef DOXYGEN_H
#define DOXYGEN_H

/**
   \mainpage Lattice QCD common code development Project
   \section intro [Introduction]
    Bridge++ is a code sets for performing calculations in lattice QCD on linux workstation, and  \n
    supercomputers using "C/C++" standard language with MPI.
    \n

   \section environmen [Environment]
        - LinuxWS
            -# GNU C++ 4.x  (Single/OpenMPI)
            -# Intel C++ ver.11.x  (Single/OpenMPI)
            -# PGI Compiler 12.x (Single/OpenMPI)
        - Hitachi SR16000
            -# AIX: xlc++ (KEK, YITP) (Single/MPI) \n
        - IBM Blue Gene/Q
            -# AIX/Red Hat ELS 6.2(Cross Compiler): xlc++ (KEK) (single/MPI) \n
        - Fujitsu FX10
            -# XTCOS/Red Hat ELS(Cross Compiler):   fcc (Univ. Tokyo) \n
        \n
   \section install [Install]
    \subsection step1 Step1: cd to code set top dir.

    \subsection step2 Step2: change Makefile appropriately.
    (default is g++ on single node.) \n
    If you are unsure, a script is provided to generate a Makefile
    through interactive menu as follows:

    \code
    $ ./makeconfig.sh
    \endcode

    \subsection step3 Step3: Run make
    \code
    $ make
    \endcode
    or
    \code
    $ gmake
    \endcode

    "build/bridge.elf" is created by make.
    and sample data file copied from "src/Main/" dir. to "build" dir.

    \subsection step4 Step4: Execution of a program
    \code
    $ make run
    \endcode
    or
    \code
    $ cd build; ./bridge.elf
    \endcode

    Without any change of source code, test manager runs on a 4x4x4x8 lattice.
    \n
    \n

   \section docs [More documentation]
        <a href="http://www7303ui.sakura.ne.jp/dokuwiki/doku.php?id=first_step_guide">
        Bridge++ First Step Guide on wiki page (only Japanese site)
        </a>

        <a href="http://www7303ui.sakura.ne.jp/dokuwiki/doku.php?id=%E3%82%B3%E3%83%BC%E3%83%89%E5%AE%9F%E8%A3%85%E3%82%AC%E3%82%A4%E3%83%89">
        Bridge++ Implementation Guide on wiki page (only Japanese site)
        </a>

        <a href="http://bridge.kek.jp/Lattice-code/">
        Lattice QCD common code Bridge++ Project Site
        </a>
    \n


   \section auther [Authors]
   \subsection project_member Project Member
   Shinya    Aoki      (Kyoto Univ.)\n
   Tatsumi   Aoyama    (Nagoya Univ.)\n
   Kazuyuki  Kanaya    (Univ. of Tsukuba)\n
   Hideo     Matsufuru (KEK)\n
   Shinji    Motoki    (Aizu Univ.)\n
   Yusuke    Namekawa  (Univ. of Tsukuba)\n
   Hidekatsu Nemura    (Univ. of Tsukuba)\n
   Yusuke    Taniguchi (Univ. of Tsukuba)\n
   Satoru    Ueda      (KEK)\n
   Naoya     Ukita     (Univ. of Tsukuba)\n

   \subsection contributer Contributer
   Takumi    Doi       (REKEN)\n
   Guido     Cossu     (KEK)\n
   Shoji     Hashimoto (KEK)\n
   Noriyoshi Ishii     (Univ. of Tsukuba, AICS)\n
   Ken-ichi  Ishikawa  (Hiroshima Univ.)\n
   Takashi   Kaneko    (KEK)\n
   Yoshinobu Kuramashi (Univ. of Tsukuba)\n
   Jun-Ichi  Noaki     (KEK)\n
   Kenji     Ogawa     (National Chiao Tung University)\n
   Hana      Saito     (Univ. of Tsukuba)\n
   Kenji     Sasaki    (Univ. of Tsukuba)\n
   Tomoteru  Yoshie    (Univ. of Tsukuba)\n

   \section history [History]
    - 2013/07/22    Version 1.1 Release.
    - 2012/07/25    Version 1.0 Release.
    - \date 2009-2013
 */
#endif //DOXYGEN_H

//        - NEC SX9
//            -# SUPER-UX/SuSE Linux(Cross Compiler): sxc++ (RNCP) (Single/MPI) \n
//   \section docs documentation
//    \subsection step1 Step1: (1) cd to code set top dir.
//    $ make doxygen
//    You can find doxygen files in "docs/html" dir.
//
//    \subsection step2 Step2: (2) if your system not installed doxygen command.
//    $ make mkdoxygen
//    after that extra/doxygen-1.8.1.2 was compiled, to be executed as well as (1).

//   \section refference Refference
//    - [ref]
//    - [ref]
