/**
*        @file    $Id:: main.cpp #$
*
*        @brief
*
*        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
*                 $LastChangedBy: sueda $
*
*        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$
*
*        @version $LastChangedRevision: 930 $
**/

#include "main.h"

//====================================================================
int main(int argc, char *argv[])
{
  // ###  initial setup  ###
  Bridge::vout.init(std::cout);
  Bridge::vout.ildg_init(std::cout);
  Bridge::VerboseLevel vl = Bridge::GENERAL;

  Communicator::init(&argc, &argv);


  // ####  parameter setup  ####
  Parameters_Main params_main;

  Parameters params_all;

  params_all.Register_Parameters("Main", &params_main);

  string filename_input = filename_main_input;
  if (filename_input == "stdin") {
    vout.general(vl, "input filename : ");
    std::cin >> filename_input;
    vout.general(vl, "%s\n", filename_input.c_str());
  } else {
    vout.general(vl, "input filename : %s\n", filename_input.c_str());
  }
  vout.general(vl, "\n");

  ParameterManager_YAML params_manager;
  params_manager.read_params(filename_input, &params_all);

  const valarray<int> lattice_size     = params_main.get_int_vector("lattice_size");
  const valarray<int> grid_size        = params_main.get_int_vector("grid_size");
  const string        str_logfile      = params_main.get_string("log_filename");
  const string        str_ildg_logfile = params_main.get_string("ildg_log_filename");
  const string        str_vlevel       = params_main.get_string("verbose_level");


  //- initializations
  vl = vout.set_verbose_level(str_vlevel);

  std::ofstream logfile(str_logfile.c_str());
  std::ofstream ildg_logfile(str_ildg_logfile.c_str());

  if (str_logfile != "stdout") {
    Bridge::vout.init(logfile);
  }
  if (str_ildg_logfile != "stdout") {
    Bridge::vout.ildg_init(ildg_logfile);
  }

  CommonParameters::init(lattice_size, grid_size);
  Communicator::setup();

  int Ndim = CommonParameters::Ndim();
  int Nvol = CommonParameters::Nvol();


  //- print input parameters
  vout.general(vl, "Parameters of Main:\n");
  for (int mu = 0; mu < Ndim; ++mu) {
    vout.general(vl, "  lattice_size[%d] = %d\n", mu, lattice_size[mu]);
    vout.general(vl, "  grid_size[%d]    = %d\n", mu, grid_size[mu]);
  }
  vout.general(vl, "  logfile          = %s\n", str_logfile.c_str());
  vout.general(vl, "  ildg_logfile     = %s\n", str_ildg_logfile.c_str());
  vout.general(vl, "  vlevel           = %s\n", str_vlevel.c_str());
  vout.general(vl, "\n");

  //- input parameter check
  int err = 0;
  err += ParameterCheck::non_NULL(str_logfile);
  err += ParameterCheck::non_NULL(str_ildg_logfile);

  if (err) {
    vout.crucial(vl, "Main: input parameters have not been set.\n");
    abort();
  }


  //- timestamp (starting time)
  Timer *timer = new Timer;
  timer->timestamp();


#ifdef USE_TESTMANAGER
  run_testmanager(argc, argv);
#else
  run_test();
#endif


  //- timestamp (end time)
  timer->timestamp();


  // ####  tydy up  ####
  delete timer;


  Communicator::finalize();

  return EXIT_SUCCESS;
}


//====================================================================
//============================================================END=====
