/**
*        @file    $Id:: main.h #$
*
*        @brief
*
*        @author  $LastChangedBy: sueda $
*
*        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$
*
*        @version $LastChangedRevision: 936 $
**/

#ifndef MAIN_INCLUDED
#define MAIN_INCLUDED

#include <iostream>
#include <fstream>
#include <string>
using std::string;
#include <valarray>
using std::valarray;

#include "configure.h"
#include "defs.h"
#include "parameters.h"
#include "parameterManager_YAML.h"

#include "bridgeIO.h"
using Bridge::vout;

#include "timer.h"

const string filename_main_input = "main.yaml";
// const string filename_main_input = "stdin";

//- prototype declaration
#ifdef USE_TESTMANAGER
int run_testmanager(int argc, char **argv);

#else
int run_test();
#endif

class Parameters_Main : public Parameters
{
 public:
  Parameters_Main()
  {
    Register_int_vector("lattice_size", valarray<int>());
    Register_int_vector("grid_size", valarray<int>());

    Register_string("log_filename", "NULL");
    Register_string("ildg_log_filename", "NULL");

    Register_string("verbose_level", "NULL");
  }
};
#endif
