/*
        @file    $Id: run_test.cpp #$

        @brief

        @author
                 $LastChangedBy: sueda $

        @date    $LastChangedDate: 2013-04-08 18:00:27 #$

        @version $LastChangedRevision: 943 $
*/

#include "main.h"
#include "testlist.h"

//====================================================================
int run_test()
{
  Test_HMC_Clover::leapfrog_Nf2();
  Test_HMC_Clover::RHMC_Nf2p1();

  Test_HMC_Clover_SF::leapfrog_Nf2();
  Test_HMC_Clover_SF::RHMC_Nf2p1();

  Test_HMC_Quenched::leapfrog();

  Test_HMC_Wilson::leapfrog_Nf2();

  Test_Spectrum_Clover::hadron_2ptFunction();
  Test_Spectrum_Clover::hadron_2ptFunction_eo();
  Test_Spectrum_Clover::hadron_2ptFunction_withFileIO();
  Test_Spectrum_Clover::hadron_2ptFunction_eo_withFileIO();

  Test_Spectrum_Wilson::hadron_2ptFunction();
  Test_Spectrum_Wilson::hadron_2ptFunction_eo();

#ifdef USE_MPI
  // these tests run only in single-node environment.
#else
  //- NB. CRS tests are skipped, because they are time-consuming.
  // Test_Spectrum_CRSMatrix::clover_lex();
  // Test_Spectrum_CRSMatrix::domainwall();
  // Test_Spectrum_CRSMatrix::overlap_5d();
#endif


  Test_Gauge::plaquette();
  Test_Gauge::shift();

  Test_WilsonLoop::wilsonloop();

  Test_SF_fAfP::boundary_meson_2ptFunction();

  Test_GradientFlow::update();

  Test_Eigensolver::solve();
  Test_Eigensolver::solve_chebyshev();
  Test_Eigensolver::solve_SF();

  Test_Rational::approx();
  Test_Rational::inverse();
  Test_Rational::smeared_rational();

  Test_ShiftSolver::solve();

  Test_RandomNumbers::uniform_calc_pi();
  Test_RandomNumbers::gaussian();
  Test_RandomNumbers::gaussian_field();

  Test_IO_GaugeConfig::test_io_gconf_text();
  Test_IO_GaugeConfig::test_io_gconf_binary();
  Test_IO_GaugeConfig::test_io_gconf_fortran();
  Test_IO_GaugeConfig::test_io_gconf_ILDG();
  Test_IO_GaugeConfig::test_io_gconf_binary_parallel();

  Test_IO_Data::test_io_data_text();

  return 0;
}
