/*
        @file    $Id: run_testmanager.cpp #$

        @brief

        @author
                 $LastChangedBy: sueda $

        @date    $LastChangedDate: 2013-04-12 13:28:01 #$

        @version $LastChangedRevision: 930 $
*/

#include "main.h"
#include "test.h"
#include "testlist.h"
#include "testManager.h"

//====================================================================
int run_testmanager(int argc, char **argv)
{
  TestManager& testmanager = TestManager::Instance();  // find singleton

#ifdef USE_TESTMANAGER_AUTOREGISTER
  //- tests are registered automatically at start up.

#else
  //- register tests manually:
  //
  // testmanager.registerTest(
  //   "Gauge.Plaquette",
  //   Test_Gauge::plaquette
  // );
#endif

  if (argc > 1) {
    for (int i = 1; i < argc; ++i) {
      testmanager.batch(argv[i]);
    }
  } else {
    testmanager.interactive();
  }

  return 0;
}
