#include "contract_4spinor.h"
#include "index_lex.h"

#include <cassert>

#define NC    3
#define C1    0
#define C2    1
#define C3    2

//====================================================================
void contract_at_t(dcomplex& corr, const GammaMatrix& gm,
                   const Field_F& v1, const Field_F& v2, int time)
{
  int Nc   = CommonParameters::Nc();
  int Nd   = CommonParameters::Nd();
  int Nx   = CommonParameters::Nx();
  int Ny   = CommonParameters::Ny();
  int Nz   = CommonParameters::Nz();
  int Nt   = CommonParameters::Nt();
  int Nvol = CommonParameters::Nvol();

  assert(Nvol == v1.nvol());
  assert(Nvol == v2.nvol());
  assert(time < Nt);

  Index_lex        index;
  valarray<int>    gmindex(Nd);
  valarray<double> corr_r(Nd), corr_i(Nd);

  for (int i = 0; i < Nd; ++i) {
    gmindex[i] = gm.index(i);
    corr_r[i]  = 0.0;
    corr_i[i]  = 0.0;
  }

  for (int z = 0; z < Nz; ++z) {
    for (int y = 0; y < Ny; ++y) {
      for (int x = 0; x < Nx; ++x) {
        int site = index.site(x, y, z, time);

        for (int s0 = 0; s0 < Nd; ++s0) {
          int s1 = gmindex[s0];

          for (int c1 = 0; c1 < Nc; ++c1) {
            corr_r[s0] += v1.cmp_r(c1, s1, site) * v2.cmp_r(c1, s0, site)
                          + v1.cmp_i(c1, s1, site) * v2.cmp_i(c1, s0, site);

            corr_i[s0] += v1.cmp_r(c1, s1, site) * v2.cmp_i(c1, s0, site)
                          - v1.cmp_i(c1, s1, site) * v2.cmp_r(c1, s0, site);
          }
        }
      }
    }
  }

  corr = dcomplex(0.0, 0.0);
  for (int s0 = 0; s0 < Nd; ++s0) {
    corr += gm.value(s0) * dcomplex(corr_r[s0], corr_i[s0]);
  }
}


//====================================================================
void contract_at_t(dcomplex& corr, const GammaMatrix& gm, int d3,
                   const Field_F& v1, const Field_F& v2, const Field_F& v3,
                   int time)
{
  int Nc   = CommonParameters::Nc();
  int Nd   = CommonParameters::Nd();
  int Nx   = CommonParameters::Nx();
  int Ny   = CommonParameters::Ny();
  int Nz   = CommonParameters::Nz();
  int Nt   = CommonParameters::Nt();
  int Nvol = CommonParameters::Nvol();

  assert(Nc == 3);
  assert(Nvol == v1.nvol());
  assert(Nvol == v2.nvol());
  assert(Nvol == v3.nvol());
  assert(time < Nt);

  Index_lex        index;
  valarray<int>    gmindex(Nd);
  valarray<double> cr(Nd), ci(Nd);

  for (int i = 0; i < Nd; ++i) {
    gmindex[i] = gm.index(i);
    cr[i]      = 0.0;
    ci[i]      = 0.0;
  }

  for (int z = 0; z < Nz; ++z) {
    for (int y = 0; y < Ny; ++y) {
      for (int x = 0; x < Nx; ++x) {
        int site = index.site(x, y, z, time);

        for (int d1 = 0; d1 < Nd; ++d1) {
          int d2 = gmindex[d1];

          cr[d1] += (v1.cmp_r(C1, d1, site) * v2.cmp_r(C2, d2, site)
                     - v1.cmp_i(C1, d1, site) * v2.cmp_i(C2, d2, site)) * v3.cmp_r(C3, d3, site)
                    - (v1.cmp_r(C1, d1, site) * v2.cmp_i(C2, d2, site)
                       + v1.cmp_i(C1, d1, site) * v2.cmp_r(C2, d2, site)) * v3.cmp_i(C3, d3, site);
          ci[d1] += (v1.cmp_r(C1, d1, site) * v2.cmp_r(C2, d2, site)
                     - v1.cmp_i(C1, d1, site) * v2.cmp_i(C2, d2, site)) * v3.cmp_i(C3, d3, site)
                    + (v1.cmp_r(C1, d1, site) * v2.cmp_i(C2, d2, site)
                       + v1.cmp_i(C1, d1, site) * v2.cmp_r(C2, d2, site)) * v3.cmp_r(C3, d3, site);

          cr[d1] += (v1.cmp_r(C2, d1, site) * v2.cmp_r(C3, d2, site)
                     - v1.cmp_i(C2, d1, site) * v2.cmp_i(C3, d2, site)) * v3.cmp_r(C1, d3, site)
                    - (v1.cmp_r(C2, d1, site) * v2.cmp_i(C3, d2, site)
                       + v1.cmp_i(C2, d1, site) * v2.cmp_r(C3, d2, site)) * v3.cmp_i(C1, d3, site);
          ci[d1] += (v1.cmp_r(C2, d1, site) * v2.cmp_r(C3, d2, site)
                     - v1.cmp_i(C2, d1, site) * v2.cmp_i(C3, d2, site)) * v3.cmp_i(C1, d3, site)
                    + (v1.cmp_r(C2, d1, site) * v2.cmp_i(C3, d2, site)
                       + v1.cmp_i(C2, d1, site) * v2.cmp_r(C3, d2, site)) * v3.cmp_r(C1, d3, site);

          cr[d1] += (v1.cmp_r(C3, d1, site) * v2.cmp_r(C1, d2, site)
                     - v1.cmp_i(C3, d1, site) * v2.cmp_i(C1, d2, site)) * v3.cmp_r(C2, d3, site)
                    - (v1.cmp_r(C3, d1, site) * v2.cmp_i(C1, d2, site)
                       + v1.cmp_i(C3, d1, site) * v2.cmp_r(C1, d2, site)) * v3.cmp_i(C2, d3, site);
          ci[d1] += (v1.cmp_r(C3, d1, site) * v2.cmp_r(C1, d2, site)
                     - v1.cmp_i(C3, d1, site) * v2.cmp_i(C1, d2, site)) * v3.cmp_i(C2, d3, site)
                    + (v1.cmp_r(C3, d1, site) * v2.cmp_i(C1, d2, site)
                       + v1.cmp_i(C3, d1, site) * v2.cmp_r(C1, d2, site)) * v3.cmp_r(C2, d3, site);

          cr[d1] -= (v1.cmp_r(C3, d1, site) * v2.cmp_r(C2, d2, site)
                     - v1.cmp_i(C3, d1, site) * v2.cmp_i(C2, d2, site)) * v3.cmp_r(C1, d3, site)
                    - (v1.cmp_r(C3, d1, site) * v2.cmp_i(C2, d2, site)
                       + v1.cmp_i(C3, d1, site) * v2.cmp_r(C2, d2, site)) * v3.cmp_i(C1, d3, site);
          ci[d1] -= (v1.cmp_r(C3, d1, site) * v2.cmp_r(C2, d2, site)
                     - v1.cmp_i(C3, d1, site) * v2.cmp_i(C2, d2, site)) * v3.cmp_i(C1, d3, site)
                    + (v1.cmp_r(C3, d1, site) * v2.cmp_i(C2, d2, site)
                       + v1.cmp_i(C3, d1, site) * v2.cmp_r(C2, d2, site)) * v3.cmp_r(C1, d3, site);

          cr[d1] -= (v1.cmp_r(C2, d1, site) * v2.cmp_r(C1, d2, site)
                     - v1.cmp_i(C2, d1, site) * v2.cmp_i(C1, d2, site)) * v3.cmp_r(C3, d3, site)
                    - (v1.cmp_r(C2, d1, site) * v2.cmp_i(C1, d2, site)
                       + v1.cmp_i(C2, d1, site) * v2.cmp_r(C1, d2, site)) * v3.cmp_i(C3, d3, site);
          ci[d1] -= (v1.cmp_r(C2, d1, site) * v2.cmp_r(C1, d2, site)
                     - v1.cmp_i(C2, d1, site) * v2.cmp_i(C1, d2, site)) * v3.cmp_i(C3, d3, site)
                    + (v1.cmp_r(C2, d1, site) * v2.cmp_i(C1, d2, site)
                       + v1.cmp_i(C2, d1, site) * v2.cmp_r(C1, d2, site)) * v3.cmp_r(C3, d3, site);

          cr[d1] -= (v1.cmp_r(C1, d1, site) * v2.cmp_r(C3, d2, site)
                     - v1.cmp_i(C1, d1, site) * v2.cmp_i(C3, d2, site)) * v3.cmp_r(C2, d3, site)
                    - (v1.cmp_r(C1, d1, site) * v2.cmp_i(C3, d2, site)
                       + v1.cmp_i(C1, d1, site) * v2.cmp_r(C3, d2, site)) * v3.cmp_i(C2, d3, site);
          ci[d1] -= (v1.cmp_r(C1, d1, site) * v2.cmp_r(C3, d2, site)
                     - v1.cmp_i(C1, d1, site) * v2.cmp_i(C3, d2, site)) * v3.cmp_i(C2, d3, site)
                    + (v1.cmp_r(C1, d1, site) * v2.cmp_i(C3, d2, site)
                       + v1.cmp_i(C1, d1, site) * v2.cmp_r(C3, d2, site)) * v3.cmp_r(C2, d3, site);
        }
      }
    }
  }

  corr = dcomplex(0.0, 0.0);
  for (int s0 = 0; s0 < Nd; ++s0) {
    corr += gm.value(s0) * dcomplex(cr[s0], ci[s0]);
  }
}
