#ifndef CONTRACT_H_INCLUDED
#define CONTRACT_H_INCLUDED

#include "bridge_complex.h"
#include "gammaMatrix.h"
#include "field_F.h"

//! contraction for meson at a given time t.
void contract_at_t(dcomplex& corr, const GammaMatrix& gm,
                   const Field_F& f1, const Field_F& f2, int time);

//! contraction for baryon (Nc=3 case only) at a given time t.
void contract_at_t(dcomplex& corr,
                   const GammaMatrix&, int id3,
                   const Field_F& f1, const Field_F& f2,
                   const Field_F& f3, int time);
#endif /* CONTRACT_H_INCLUDED */
