/*!
        @file    $Id:: fprop.h #$

        @brief

        @author  Satoru Ueda <sueda@post.kek.jp> (sueda)
                 $LastChangedBy: namekawa $

        @date    $LastChangedDate:: 2013-04-08 18:00:27 #$

        @version $LastChangedRevision: 860 $
*/

#ifndef FPROP_INCLUDED
#define FPROP_INCLUDED

#include "fopr.h"
#include "bridgeIO.h"

class Fprop
{
 protected:
  Bridge::VerboseLevel m_vl;

 public:

  Fprop()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~Fprop() {}

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual void invert_D(Field&, const Field&, int&, double&)     = 0;
  virtual void invert_DdagD(Field&, const Field&, int&, double&) = 0;

  virtual void set_config(Field *) = 0;
};
#endif
