/*!
        @file    $Id:: fprop_4spinor_lex.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: aoym $

        @date    $LastChangedDate:: 2013-03-21 15:28:34 #$

        @version $LastChangedRevision: 854 $
*/

#include "fprop_4spinor_lex.h"

//====================================================================
void Fprop_4spinor_lex::calc(Field_F *xq, const Field_F& b)
{
  int    Niter     = 500;
  double Stop_cond = 1.0e-24;

  int    Nconv;
  double diff;

  // CGNE solver
  Field_F *b2 = new Field_F;

  m_fopr->set_mode("Ddag");
  *b2 = (Field_F)m_fopr->mult(b);

  Solver *solver = new Solver_CG(m_fopr);
  solver->set_parameters(Niter, Stop_cond);
  m_fopr->set_mode("DdagD");

  //  solver->solve((Field)(*xq),(Field)(*b2),Nconv,diff);
  solver->solve(*xq, *b2, Nconv, diff);

  vout.general(m_vl, "  Nconv = %d\n", Nconv);
  vout.general(m_vl, "  diff  = %.8e\n", diff);

  delete solver;
  delete b2;
}
