/*!
        @file    $Id:: fprop_4spinor_lex.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: aoym $

        @date    $LastChangedDate:: 2013-03-21 15:28:34 #$

        @version $LastChangedRevision: 854 $
*/

#ifndef FPROP_4SPINOR_LEX_INCLUDED
#define FPROP_4SPINOR_LEX_INCLUDED

#include "fopr_Wilson.h"
#include "solver_CG.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Get quark propagator for Fopr with 4-spinor and lexical site index.

/*!
    This is temporary implementation.
                                        [28 Dec 2011 H.Matsufuru]
 */

class Fprop_4spinor_lex
{
 protected:
  Bridge::VerboseLevel m_vl;

 private:
  Fopr *m_fopr;

 public:
  Fprop_4spinor_lex(Fopr *fopr)
    : m_vl(CommonParameters::Vlevel()), m_fopr(fopr) {}

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  void calc(Field_F *, const Field_F&);
};
#endif
