/*!
        @file    $Id:: fprop_Standard_eo.cpp #$

        @brief

        @author  Satoru Ueda<sueda@post.kek.jp> (sueda)
                 $LastChangedBy: namekawa $

        @date    $LastChangedDate:: 2013-04-08 18:00:27 #$

        @version $LastChangedRevision: 860 $
*/

#include "fprop_Standard_eo.h"

//====================================================================
void Fprop_Standard_eo::set_config(Field *U)
{
  m_index->convertField(*m_Ueo, *U);

  // m_solver->get_fopr()->set_config(m_Ueo);
  m_solver->get_fopr()->set_config(U);
}


//====================================================================
void Fprop_Standard_eo::invert_D(Field& xq, const Field& b, int& Nconv, double& diff)
{
  int Nin  = b.nin();
  int Nvol = b.nvol();
  int Nex  = b.nex();

  Field Be(Nin, Nvol / 2, Nex);
  Field bo(Nin, Nvol / 2, Nex);
  Field xe(Nin, Nvol / 2, Nex);

  int Nconv1;

  Fopr_eo *fopr = (Fopr_eo *)m_solver->get_fopr();

  fopr->set_mode("D");
  fopr->preProp(Be, bo, b);
  m_solver->solve(xe, Be, Nconv1, diff);
  fopr->postProp(xq, xe, bo);

  //- NB. #mult is doubled for even-odd
  Nconv = 2 * Nconv1;
}


//====================================================================
void Fprop_Standard_eo::invert_DdagD(Field& xq, const Field& b, int& Nconv, double& diff)
{
  int Nin  = b.nin();
  int Nvol = b.nvol();
  int Nex  = b.nex();

  Field Be(Nin, Nvol / 2, Nex);
  Field bo(Nin, Nvol / 2, Nex);
  Field xe(Nin, Nvol / 2, Nex);

  int    Nconv1, Nconv2;
  double diff1, diff2;

  Fopr_eo *fopr = (Fopr_eo *)m_solver->get_fopr();

  fopr->set_mode("Ddag");
  fopr->preProp(Be, bo, b);
  m_solver->solve(xe, Be, Nconv1, diff1);
  fopr->postProp(xq, xe, bo);

  fopr->set_mode("D");
  fopr->preProp(Be, bo, xq);
  m_solver->solve(xe, Be, Nconv2, diff2);
  fopr->postProp(xq, xe, bo);

  //- NB. #mult is doubled for even-odd
  Nconv = 2 * (Nconv1 + Nconv2);

  //- rough estimate of diff
  diff = (diff1 + diff2) / 2.0;
}


//====================================================================
//============================================================END=====
