/*!
        @file    $Id:: fprop_Standard_eo.h #$

        @brief

        @author  Satoru Ueda <sueda@post.kek.jp> (sueda)
                 $LastChangedBy: namekawa $

        @date    $LastChangedDate:: 2013-04-08 18:00:27 #$

        @version $LastChangedRevision: 860 $
*/

#ifndef FPROP_STANDARD_EO_INCLUDED
#define FPROP_STANDARD_EO_INCLUDED

#include "fprop.h"
#include "field_G.h"

#include "fopr_eo.h"
#include "index_eo.h"

#include "solver.h"

//! Get quark propagator for Fopr with even-odd site index.

/*!
    This is temporary implementation.
                                        [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    Modify this code to work.           [03 Mar 2013 Y.Namekawa]
 */

class Fprop_Standard_eo : public Fprop
{
 public:

  Fprop_Standard_eo(Solver *solver)
    : Fprop(), m_solver(solver)
  {
    m_index = new Index_eo;
    m_Ueo   = new Field_G(CommonParameters::Nvol(), CommonParameters::Ndim());
  }

  ~Fprop_Standard_eo()
  {
    delete m_index;
    delete m_Ueo;
  }

  void set_config(Field *);

  void invert_D(Field&, const Field&, int&, double&);
  void invert_DdagD(Field&, const Field&, int&, double&);


 private:
  Solver  *m_solver;
  Field_G *m_Ueo;

  Index_eo *m_index;
};
#endif
