/*!
        @file    $Id:: fprop_Standard_lex.cpp #$

        @brief

        @author  Satoru Ueda <sueda@post.kek.jp> (ueda)
                 $LastChangedBy: namekawa $

        @date    $LastChangedDate:: 2013-04-08 18:00:27 #$

        @version $LastChangedRevision: 860 $
*/

#include "fprop_Standard_lex.h"

//====================================================================
void Fprop_Standard_lex::set_config(Field *U)
{
  m_solver->get_fopr()->set_config(U);
}


//====================================================================
void Fprop_Standard_lex::invert_D(Field& xq, const Field& b, int& Nconv, double& diff)
{
  m_solver->get_fopr()->set_mode("D");
  m_solver->solve(xq, b, Nconv, diff);
}


//====================================================================
void Fprop_Standard_lex::invert_DdagD(Field& xq, const Field& b, int& Nconv, double& diff)
{
  m_solver->get_fopr()->set_mode("DdagD");
  m_solver->solve(xq, b, Nconv, diff);
}


//====================================================================
//============================================================END=====
