/*!
        @file    $Id:: fprop_Wilson_Shift.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: aoym $

        @date    $LastChangedDate:: 2013-04-27 12:28:50 #$

        @version $LastChangedRevision: 875 $
*/

#ifndef FPROP_WILSON_SHIFT_INCLUDED
#define FPROP_WILSON_SHIFT_INCLUDED

#include "fopr_Wilson.h"
#include "index_lex.h"
#include "shiftsolver_CG.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Get shifted quark propagators.

/*!
    This class is used to determine the shifted quark propagator
    with multishift solver.
    Present implementation is temporary to test the shiftsolver.
                                      [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.              [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Fprop_Wilson_Shift : virtual public Parameters
{
 public:
  Parameters_Fprop_Wilson_Shift();
};
//- end

class Fprop_Wilson_Shift
{
 protected:
  Bridge::VerboseLevel m_vl;

 private:
  Fopr_Wilson *m_fopr;
  Index_lex   *m_index_lex;

  int    m_Niter;
  double m_Stop_cond;

  int m_Nshift;
  std::valarray<double> m_sigma;

 public:
  Fprop_Wilson_Shift(Fopr_Wilson *fopr, Index_lex *index)
    : m_vl(CommonParameters::Vlevel()),
      m_fopr(fopr), m_index_lex(index) {}

  void set_parameters(const Parameters& params);
  void set_parameters(const int Nshift, const std::valarray<double> sigma,
                      const int Niter, const double Stop_cond);

  double calc(std::valarray<Field_F> *,
              const Field_F&);
};
#endif
