/*!
        @file    $Id:: noiseVector.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef NOISEVECTOR_INCLUDED
#define NOISEVECTOR_INCLUDED

#include "defs.h"
#include "commonParameters.h"
#include "field.h"
#include "bridgeIO.h"

//! Base class for noise vector generator.

/*!
    This is the base class of noise vector generator for
    trace calculations.
    This class only defines the interface.
                                     [2 Sep 2012 H.Matsufuru]
 */

class NoiseVector
{
 protected:
  Bridge::VerboseLevel m_vl;

 public:

  NoiseVector()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~NoiseVector() {}

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  //! setting a noise vector.
  virtual void set(Field& v) = 0;
};
#endif
