/*!
        @file    $Id:: noiseVector_Z2.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#include "noiseVector_Z2.h"

//====================================================================
void NoiseVector_Z2::set(Field& v)
{
  // This implementation assumes the given field v is complex field.

  m_rand->uniform_lex_global(v);

  int    Nex  = v.nex();
  int    Nvol = v.nvol();
  int    Nin  = v.nin();
  double rn, rn2, rn3;
  double RF2 = 1.0 / sqrt(2.0);

  for (int ex = 0; ex < Nex; ++ex) {
    for (int site = 0; site < Nvol; ++site) {
      for (int in = 0; in < Nin; ++in) {
        rn  = v.cmp(in, site, ex);
        rn2 = floor(2.0 * rn);
        rn3 = (2.0 * rn2 - 1.0) * RF2;
        v.set(in, site, ex, rn3);
      }
    }
  }
}


//====================================================================
//============================================================END=====
