/*!
        @file    $Id:: source.h #$

        @brief

        @author  Tatsumi Aoyama <aoym@post.kek.jp> (aoym)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef SOURCE_INCLUDED
#define SOURCE_INCLUDED

#include <valarray>
#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "field.h"
#include "bridgeIO.h"

#ifdef USE_FACTORY
#include "factory.h"
#endif

//! Base class of sources for a linear solver.

/*!
    (Coding history will be recovered from trac.)
    Parameters_Source_All is implemented for source_selector.
                                      [2 Feb 2013 Y.Namekawa]
 */

class Source
{
 protected:
  Bridge::VerboseLevel m_vl;

 public:
  Source() {}
  virtual ~Source() {}

  virtual void set_parameters(const Parameters&) = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual void set(Field&, int) = 0;

#ifdef USE_FACTORY
 public:
  typedef Source *(*ProductCreator)();
  typedef FactoryTemplate<Source, ProductCreator>   Factory;

  static Source *New(const IdentifierType& subtype)
  {
    ProductCreator p = Factory::Find(subtype);

    return p ? (*p)() : 0;
  }
#endif
};
#endif /* SOURCE_INCLUDED */
