/*!
        @file    $Id:: source_4spinor_Exp.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef SOURCE_4SPINOR_EXP_INCLUDED
#define SOURCE_4SPINOR_EXP_INCLUDED

#include "field_F.h"
#include "index_lex.h"
#include "parameters.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Exponentially smeared source for 4-spinor fermion.

/*!
    This class sets an exponentially smeared source vector
    for the 4-spinor (Wilson-type) fermion.
                                 [19 Feb 2012 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.         [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Source_4spinor_Exp : virtual public Parameters
{
 public:
  Parameters_Source_4spinor_Exp();
};
//- end

class Source_4spinor_Exp
{
 protected:
  Bridge::VerboseLevel m_vl;

 private:
  std::valarray<int> m_source_position;
  double             m_slope, m_power;
  Index_lex          m_index;
  Field              m_src_func;

 public:

  Source_4spinor_Exp()
    : m_vl(CommonParameters::Vlevel()) {}

  void set_parameters(const Parameters& params);
  void set_parameters(std::valarray<int>& source_position,
                      double slope, double power);

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  void set(Field_F& src, int ic, int id);
};
#endif
