/*!
        @file    $Id:: source_Exponential.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef SOURCE_EXPONENTIAL_INCLUDED
#define SOURCE_EXPONENTIAL_INCLUDED

#include "source.h"
#include "index_lex.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Source_Exponential : virtual public Parameters
{
 public:
  Parameters_Source_Exponential();
};
//- end

//! Exponentially smeared source for 4-spinor fermion.

/*!
    This class sets an exponentially smeared source vector
    for the 4-spinor (Wilson-type) fermion.
                                      [19 Feb 2012 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.              [14 Nov 2012 Y.Namekawa]
 */

class Source_Exponential : public Source
{
 public:

  Source_Exponential() {}

  void set_parameters(const Parameters& params);
  void set_parameters(const valarray<int>& source_position,
                      const double slope, const double power);

  void set(Field& v, int j);

 private:
  Index_lex     m_index;
  valarray<int> m_source_position;
  double        m_slope, m_power;
  bool          m_in_node;
  Field         m_src_func;
};
#endif /* SOURCE_EXPONENTIAL_INCLUDED */
