/*!
        @file    $Id:: source_Local.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef SOURCE_LOCAL_INCLUDED
#define SOURCE_LOCAL_INCLUDED

#include "source.h"
#include "index_lex.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Source_Local : virtual public Parameters
{
 public:
  Parameters_Source_Local();
};
//- end

//! Local source for 4-spinor fermion.

/*!
    This class sets an local source vector for the 4-spinor
    (Wilson-type) fermion.
                                     [19 Feb 2012 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.             [14 Nov 2012 Y.Namekawa]
 */

class Source_Local : public Source {
 public:

  Source_Local()
    : Source() {}

  void set_parameters(const Parameters& params);
  void set_parameters(const std::valarray<int>& source_position);

  void set(Field& v, int j);

 private:
  Index_lex          m_index; // lexical only.
  std::valarray<int> m_source_position;
  bool               m_in_node;
};
#endif /* SOURCE_LOCAL_INCLUDED */
