/*!
        @file    $Id:: source_Wall.h #$

        @brief

        @author  <Yusuke Namekawa> namekawa@ccs.tsukuba.ac.jp(namekawa)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef SOURCE_WALL_INCLUDED
#define SOURCE_WALL_INCLUDED

#include "source.h"
#include "index_lex.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Source_Wall : virtual public Parameters
{
 public:
  Parameters_Source_Wall();
};
//- end

//! Wall source for 4-spinor fermion.

/*!
    This class sets a wall source vector
    for the 4-spinor (Wilson-type) fermion.
                          [02 Feb 2013 Y.Namekawa]
 */

class Source_Wall : public Source
{
 public:
  Source_Wall() {}

  void set_parameters(const Parameters& params);
  void set_parameters(const std::valarray<int>& source_position);

  void set(Field& v, int j);

 private:
  Index_lex          m_index;
  std::valarray<int> m_source_position;
  bool               m_in_node;
};
#endif /* SOURCE_WALL_INCLUDED */
