/*!
        @file    $Id:: gaugeFixing.h #$

        @brief

        @author  <Yusuke Namekawa> namekawa@ccs.tsukuba.ac.jp(namekawa)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef GAUGEFIXING_INCLUDED
#define GAUGEFIXING_INCLUDED

#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "bridgeIO.h"
#include "field_G.h"

#ifdef USE_FACTORY
#include "factory.h"
#endif

//! gauge fixing.

/*
  This class fixes the gauge of configuration.
                                        [10 Oct 2012 Y.Namekawa]
 */

class GaugeFixing
{
 public:
  GaugeFixing()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~GaugeFixing() {}

  virtual void set_parameters(const Parameters& params) = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual void fix(Field_G& Ufix, const Field_G& Uorg) = 0;

 protected:
  Bridge::VerboseLevel m_vl;


#ifdef USE_FACTORY
 public:
  typedef GaugeFixing *(*ProductCreator)(RandomNumbers *);
  typedef FactoryTemplate<GaugeFixing, ProductCreator>   Factory;

  static GaugeFixing *New(const IdentifierType& subtype, RandomNumbers *rand)
  {
    ProductCreator p = Factory::Find(subtype);

    return p ? (*p)(rand) : 0;
  }
#endif
};
#endif
