/*!
        @file    $Id:: gaugeFixing_Landau.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef GAUGEFIXING_LANDAU_INCLUDED
#define GAUGEFIXING_LANDAU_INCLUDED

#include "gaugeFixing.h"

#include "index_eo.h"
#include "shiftField_eo.h"

#include "randomNumbers.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_GaugeFixing_Landau : virtual public Parameters
{
 public:
  Parameters_GaugeFixing_Landau();
};
//- end

//! Landau gauge fixing.

/*
    This class fix the gauge of configuration to the Landau gauge.
    The algorithm is that developed by the Los Alamos group [see the
    implementation note].
    Overrelaxation is incorporated.
    To escape the Gribov copy, if convergence is not reached within
    the iterations specified by Nreset, random gauge transformation
    is performed to reset the configuration.
    This is the reason that random number generator is needed at the
    construction of this class.

    The implementation is not complete:
    - only applies to SU(3) case: because of specific implementation
      of maxTr function (Cabibbo-Marinari maximization).
    This should be improved in the version beyond test phase.
                                        [16 Feb 2012 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.                [14 Nov 2012 Y.Namekawa]
 */

class GaugeFixing_Landau : public GaugeFixing
{
 private:

  int           m_Niter;  // max iteration number
  int           m_Nnaive; // number of naive iterations
  int           m_Nmeas;  // interval of measurements
  int           m_Nreset; // Number of iteration to reset the config.
  double        m_Enorm;  // convergence criterion
  double        m_wp;     // overrelaxation parameter
  RandomNumbers *m_rand;
  Index_eo      m_index;

 public:

  GaugeFixing_Landau(RandomNumbers *rand)
    : GaugeFixing(), m_Niter(0), m_rand(rand) {}

  ~GaugeFixing_Landau() {}

  void set_parameters(const Parameters& params);
  void set_parameters(int Niter, int Nnaive, int Nmeas,
                      int Nreset, double Enorm, double wp);

  void fix(Field_G& Ufix, const Field_G& Uorg);

  void gauge_trans_eo(Field_G& Ue, Field_G& Uo, Field_G& Geo, int Ieo);

  void set_randomGaugeTrans(Field_G& Geo);

  //! one step of gauge fixing with overrelaxation parameter wp.
  void gfix_step(Field_G& Ue, Field_G& Uo, double wp);

  void calc_SG(double& sg, double& Fval, Field_G& Ue, Field_G& Uo);
  void calc_W(Field_G& Weo, Field_G& Ue, Field_G& Uo, int Ieo);
  void calc_DLT(Field_G& Weo, Field_G& Ue, Field_G& Uo, int Ieo);

  void maxTr(Field_G&, Field_G&);
  void maxTr1(Field_G&, Field_G&);
  void maxTr2(Field_G&, Field_G&);
  void maxTr3(Field_G&, Field_G&);
};
#endif
