/*!
        @file    $Id:: gradientFlow.h #$

        @brief

        @author  <Sinya Aoki> saoki@het.ph.tsukuba.ac.jp

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef GRADIENTFLOW_INCLUDED
#define GRADIENTFLOW_INCLUDED

#include "action.h"
#include "staples.h"

#include "bridgeIO.h"
using Bridge::vout;

//! GradientFlow construction.

/*!
    This is written by S. Aoki, based on staple.h
                               [01 July 2012 S.Aoki]
    (Coding history will be recovered from trac.)
    YAML is implemented.       [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_GradientFlow : virtual public Parameters
{
 public:
  Parameters_GradientFlow();
};
//- end

class GradientFlow
{
 protected:
  Bridge::VerboseLevel m_vl;

 private:
  int    m_order_RK;
  double m_Estep;
  int    m_Nstep;
  int    m_Nprec;

  Action  *m_action;
  Field_G iP, iPP, iP1, iP2;

  int Nc;
  int Ndim;
  int Nvol;
  int Lvol;

  static const double c4[];
  static const double c5[];

 public:

  GradientFlow(Action *action)
    : m_vl(CommonParameters::Vlevel()),
      Nc(CommonParameters::Nc()),
      Ndim(CommonParameters::Ndim()),
      Nvol(CommonParameters::Nvol()),
      Lvol(CommonParameters::Lvol())
  {
    // init();
    // m_action = action;
    iP.reset(Nvol, Ndim);
    iPP.reset(Nvol, Ndim);
    iP1.reset(Nvol, Ndim);
    iP2.reset(Nvol, Ndim);

    m_Nprec  = 0;
    m_Nstep  = 0;
    m_Estep  = 0.0;
    m_action = action;
  }

#if 0
  void init(void)
  {
    iP.reset(Nvol, Ndim);
    iPP.reset(Nvol, Ndim);
    iP1.reset(Nvol, Ndim);
    iP2.reset(Nvol, Ndim);

    m_Nprec = 0;
    m_Nstep = 0;
    m_Estep = 0.0;

    c4[0] = 0.25;
    c4[1] = -17.0 / 36.0;
    c4[2] = 8.0 / 9.0;
    c4[3] = 0.75;

    c5[0] = 1.0 / 6.0;
    c5[1] = 1.0 - 1.0 / sqrt(2.0);
    c5[2] = 2.0 - c5[1]; // 1.0+1.0/sqrt(2.0);
    c5[3] = c5[1] - 0.5;
    c5[4] = -4.0 * c5[2];
    c5[5] = 6.0 - 4.0 * c5[1];
    c5[6] = 1.0 / c5[3];
  }
#endif

  void update_U(double estep, Field_G& iP, Field_G& U);

  void set_parameters(const Parameters& params);
  void set_parameters(const int order_RK,
                      const double Estep, const int Nstep, const int Nprec);

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  void gradientFlow_4th(Field_G& U);
  void gradientFlow_5th(Field_G& U);

  double evolve(Field_G& U);
};
#endif
