/*!
        @file    $Id:: polyakovLoop.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef POLYAKOVLOOP_INCLUDED
#define POLYAKOVLOOP_INCLUDED

#include <cassert>
#include "parameters.h"
#include "field_G.h"
#include "shiftField_eo.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Polyakov loop measurement.

/*!
    This class determines the Polyakov loop for a given gauge
    configuration.
    It is planed that the Polyakov loop correlators are also
    measured, but still not implemented.
    For the latter case, set_parameters() is prepared (the definition
    of correlator constellation is the same as WilsonLoop).
                                 [22 Aug 2012 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.         [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_PolyakovLoop : virtual public Parameters
{
 public:
  Parameters_PolyakovLoop();
};
//- end

class PolyakovLoop
{
 protected:
  Bridge::VerboseLevel m_vl;

 private:
  //! parameters set by user
  int m_Nspc_size;     //!< spatial size of loop
  int m_Ntype;         //!< number of measured loop-type

  //! internal data members
  int m_Ntype_max;     //!< maximum size of loop-type
  int m_Nx_ext;        //!< size of extended gauge config.
  int m_Ny_ext;        //!< size of extended gauge config.
  int m_Nz_ext;        //!< size of extended gauge config.
  int m_Nt_ext;        //!< size of extended gauge config.
  int m_Nvol_ext;      //!< volume of extended gauge config.

  typedef std::valarray<int>   unitvec;
  std::valarray<unitvec> m_Nunit;
  std::valarray<int>     m_Nmax;

 public:

  PolyakovLoop()
    : m_vl(CommonParameters::Vlevel()), m_Nspc_size(0), m_Ntype(0)
  {
    init();
  }

  virtual ~PolyakovLoop() {}

  //! setting parameters: only for Polyakov loop correlators.
  virtual void set_parameters(const Parameters& params);

  void set_parameters(int Nspc_size, int Ntype);

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  //! Polyakov loop measurement
  double measure_ploop(Field_G& U);

  //! Polyakov loop correlator measurement (not implemented).
  double measure_ploop_corr(Field_G& U);

 private:

  //! Polyakov loop measurement
  void calc_ploop(Field_G& P, Field_G& U);

  //! initial setup independent of parameters.
  void init();
};
#endif
