/*!
        @file    $Id:: staples.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#include "staples.h"

//====================================================================
double Staples::plaquette(const Field_G& U)
{
  return (plaq_s(U) + plaq_t(U)) / 2;
}


//====================================================================
double Staples::plaq_s(const Field_G& U)
{
  double  plaq = 0.0;
  Field_G staple;

  staple = upper(U, 0, 1);
  for (int site = 0; site < Nvol; ++site) {
    plaq += ReTr(U.mat(site, 0) * staple.mat_dag(site));   // P_xy
  }

  staple = upper(U, 1, 2);
  for (int site = 0; site < Nvol; ++site) {
    plaq += ReTr(U.mat(site, 1) * staple.mat_dag(site));   // P_yz
  }

  staple = upper(U, 2, 0);
  for (int site = 0; site < Nvol; ++site) {
    plaq += ReTr(U.mat(site, 2) * staple.mat_dag(site));   // P_zx
  }

  plaq = Communicator::reduce_sum(plaq);

  return plaq / (Lvol * Nc * 3.0);
}


//====================================================================
double Staples::plaq_t(const Field_G& U)
{
  double  plaq = 0.0;
  Field_G staple;

  for (int nu = 0; nu < Ndim - 1; ++nu) {
    staple = lower(U, 3, nu);
    for (int site = 0; site < Nvol; ++site) {
      plaq += ReTr(U.mat(site, 3) * staple.mat_dag(site));   // P_zx
    }
  }

  plaq = Communicator::reduce_sum(plaq);

  return plaq / (Lvol * Nc * 3.0);
}


//====================================================================
void Staples::staple(Field_G& W, const Field_G& U, const int mu)
{
  W = 0.0;
  for (int nu = 0; nu < Ndim; ++nu) {
    if (nu != mu) {
      W += upper(U, mu, nu);
      W += lower(U, mu, nu);
    }
  }
}


//====================================================================
Field_G Staples::upper(const Field_G& U, const int mu, const int nu)
{
  // (1)  mu (2)
  //    +-->--+
  // nu |     |
  //   i+     +

  Field_G c;

  Umu.setpart_ex(0, U, mu);
  Unu.setpart_ex(0, U, nu);

  shift.backward(v, Unu, mu);
  shift.backward(c, Umu, nu);

  w.mult_Field_Gnd(0, c, 0, v, 0);
  c.mult_Field_Gnn(0, Unu, 0, w, 0);

  return c;
}


//====================================================================
Field_G Staples::lower(const Field_G& U, const int mu, const int nu)
{
  //    +     +
  // nu |     |
  //   i+-->--+
  //  (1)  mu (2)

  Field_G c;

  Umu.setpart_ex(0, U, mu);
  Unu.setpart_ex(0, U, nu);

  shift.backward(w, Unu, mu);
  v.mult_Field_Gnn(0, Umu, 0, w, 0);
  w.mult_Field_Gdn(0, Unu, 0, v, 0);
  shift.forward(c, w, nu);

  return c;
}


//====================================================================
//============================================================END=====
