/*!
        @file    $Id:: staples_SF.h #$

        @brief

        @author  <Yusuke Taniguchi> tanigchi@het.ph.tsukuba.ac.jp
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef STAPLES_SF_INCLUDED
#define STAPLES_SF_INCLUDED

#include <cmath>
#include "defs.h"
#include "parameters.h"
#include "field_G_SF.h"
#include "shiftField_lex.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Staple construction.

/*!
  \brief Evaluate staples with SF BC.
  <ul>
  <li>The BC parameters phi, phipr are set into SU(3) matrix wk, wkpr for boundary spatial link variable.
  <li> [26 Jan. 2012 Y.Taniguchi]
  </ul>
    (Coding history will be recovered from trac.)
    YAML is implemented.         [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Staples_SF : virtual public Parameters
{
 public:
  Parameters_Staples_SF();
};
//- end

class Staples_SF
{
 protected:
  Bridge::VerboseLevel m_vl;

 private:
  int            Nc;
  int            Ndim;
  int            Nvol, Lvol;
  Field_G_SF     Umu, Unu, v, w;
  Index_lex      index;
  ShiftField_lex shift;

  int      Nx, Ny, Nz, Nt;
  int      Lx, Ly, Lz, Lt;
  int      NPEt;
  Mat_SU_N wk, wkpr, iomega0;
  int      initialized;

 public:

  Staples_SF()
    : m_vl(CommonParameters::Vlevel()),
      Nc(CommonParameters::Nc()),
      Ndim(CommonParameters::Ndim()),
      Nvol(CommonParameters::Nvol()),
      Lvol(CommonParameters::Lvol()),
      Nx(CommonParameters::Nx()),
      Ny(CommonParameters::Ny()),
      Nz(CommonParameters::Nz()),
      Nt(CommonParameters::Nt()),
      Lx(CommonParameters::Lx()),
      Ly(CommonParameters::Ly()),
      Lz(CommonParameters::Lz()),
      Lt(CommonParameters::Lt()),
      NPEt(CommonParameters::NPEt()),
      wk(Nc), wkpr(Nc), iomega0(Nc),
      initialized(0) {}

  void set_parameters(const Parameters& params);

  void set_parameters(double *phi, double *phipr);
  void set_parameters(const double *phi, const double *phipr, const double *pomega);
  void set_parameters(std::valarray<double>& phi, std::valarray<double>& phipr, std::valarray<double>& pomega);

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  Field_G_SF upper(const Field_G&, const int, const int);
  Field_G_SF lower(const Field_G&, const int, const int);
  double plaq_s(const Field_G&);
  double plaq_t(const Field_G&);
  double plaq_t_ct(const Field_G&, double ct);
  double plaquette(const Field_G&);
  double plaquette_ct(const Field_G&, double ct);

  double sf_coupling_plaq(const Field_G&, double ct);
  double sf_coupling_rect(const Field_G&, double ctr);

  void staple(Field_G&, const Field_G&, const int);
  void staple_ct(Field_G&, const Field_G&, const int, double ct);

  void print_plaquette(const Field_G&);
};
#endif
