/*!
        @file    $Id:: staples_eo.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef STAPLES_EO_INCLUDED
#define STAPLES_EO_INCLUDED

#include "defs.h"
#include "parameters.h"
#include "field_G.h"
#include "shiftField_eo.h"

#include "bridgeIO.h"

//! Staple construction.

/*!
    While the originial version was written by J.Noaki,
    the present version is completely modified by H.Matsufuru
    except for the interface.
                               [28 Dec 2011 H.Matsufuru]
 */

class Staples_eo
{
 protected:
  Bridge::VerboseLevel m_vl;

 private:
  int Nc;
  int Ndim;
  int Nvol, Lvol;

  Field_G       Umu, Unu, v, w;
  ShiftField_eo shift;
  Communicator  *comm;

 public:
  Staples_eo()
    : m_vl(CommonParameters::Vlevel()),
      Nc(CommonParameters::Nc()),
      Ndim(CommonParameters::Ndim()),
      Nvol(CommonParameters::Nvol()),
      Lvol(CommonParameters::Lvol()) {}

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  Field_G upper(const Field_G *, const int, const int);
  Field_G lower(const Field_G *, const int, const int);
  double plaq_s(const Field_G *);
  double plaq_t(const Field_G *);
  double plaquette(const Field_G *);

  void staple(Field_G&, const Field_G *, const int);
};
#endif
