/*!
        @file    $Id:: checker.cpp #$

        @brief

        @author  Tatsumi Aoyama <aoym@post.kek.jp> (aoym)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#include "checker.h"

namespace ParameterCheck
{
  Bridge::VerboseLevel vl;


  int non_negative(const int v)
  {
    if (v < 0) {
      vout.crucial(vl, "ParameterCheck: range check error, negative int.\n");
      return EXIT_FAILURE;
    }
    return EXIT_SUCCESS;
  }


  int non_zero(const double v)
  {
    if (fabs(v) < CommonParameters::epsilon_criterion()) {
      vout.crucial(vl, "ParameterCheck: range check error, zero double.\n");
      return EXIT_FAILURE;
    }
    return EXIT_SUCCESS;
  }


  int square_non_zero(const double v)
  {
    if (fabs(v) < CommonParameters::epsilon_criterion2()) {
      vout.crucial(vl, "ParameterCheck: range check error, square_zero double.\n");
      return EXIT_FAILURE;
    }
    return EXIT_SUCCESS;
  }


  int non_zero(const int v)
  {
    if (v == 0) {
      vout.crucial(vl, "ParameterCheck: range check error, zero int.\n");
      return EXIT_FAILURE;
    }
    return EXIT_SUCCESS;
  }


  int non_NULL(const std::string v)
  {
    if (v == "NULL") {
      vout.crucial(vl, "ParameterCheck: range check error, NULL string.\n");
      return EXIT_FAILURE;
    }
    return EXIT_SUCCESS;
  }
}
