/*!
        @file    $Id:: checker.h #$

        @brief

        @author  Tatsumi Aoyama <aoym@post.kek.jp> (aoym)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

//! checker of input parameters.

/*!
    This checker examines if a parameter satisfies the specified
    condition such as non-zero. The checker returns EXIT_SUCCESS
    or EXIT_FAILURE, instead of bool in Aoyama-san's code.
                                      [16 Jun 2013 Y.Namekawa]
*/

#ifndef CHECKER_INCLUDED
#define CHECKER_INCLUDED

#include "commonParameters.h"

#include "bridgeIO.h"
using Bridge::vout;

namespace ParameterCheck
{
  typedef bool (*valid_double)(const double);
  typedef bool (*valid_int)(const int);
  typedef bool (*valid_double_vector)(const std::valarray<double>&);
  typedef bool (*valid_int_vector)(const std::valarray<int>&);
  typedef bool (*valid_string)(const std::string&);

  int non_negative(const int v);
  int non_zero(const int v);
  int non_zero(const double v);
  int square_non_zero(const double v);
  int non_NULL(const std::string v);
}
#endif
