/*!
        @file    $Id:: commonParameters.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef COMMONPARAMETERS_INCLUDED
#define COMMONPARAMETERS_INCLUDED

#include <string>
using std::string;

#include <valarray>
using std::valarray;

#include "bridgeIO.h"

//! Common parameter class: provides parameters as singleton.

/*!
    At present stage, several sets of paramters are explicitly
    given in the implementation file corresponding to some
    strings, for convenience of test.
                                      [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    epsilon_criterion is implemented. [14 Nov 2012 Y.Namekawa]
 */

class CommonParameters {
 private:

  //- color, spinor and space-time dimension
  static const int m_Nc;
  static const int m_Nd;
  static const int m_Ndim;

  static const double m_epsilon_criterion;

  //- global lattice size
  static int m_Lx, m_Ly, m_Lz, m_Lt;
  static int m_Lvol;

  //- Number of processors assigined in each direction
  static int  m_NPEx, m_NPEy, m_NPEz, m_NPEt, m_NPE;
  static char m_map_grid[16];

  //- local lattice size
  static int m_Nx, m_Ny, m_Nz, m_Nt, m_Nvol;

  static bool m_initialized;

  CommonParameters() {}
  CommonParameters(const CommonParameters&) {}
  CommonParameters& operator=(const CommonParameters&);

  // static void setup(const string&);
  static bool check_parameters();

  static Bridge::VerboseLevel m_vlevel;

 public:
  // static void init(const string&);
  static void init(const valarray<int>& lattice_size, const valarray<int>& grid_size);

  static void print_parameters();

  static int Lx() { return m_Lx; }
  static int Ly() { return m_Ly; }
  static int Lz() { return m_Lz; }
  static int Lt() { return m_Lt; }
  static int Lvol() { return m_Lvol; }

  static int NPEx() { return m_NPEx; }
  static int NPEy() { return m_NPEy; }
  static int NPEz() { return m_NPEz; }
  static int NPEt() { return m_NPEt; }
  static int NPE() { return m_NPE; }

  static char *Grid_map() { return m_map_grid; }

  static int Nx() { return m_Nx; }
  static int Ny() { return m_Ny; }
  static int Nz() { return m_Nz; }
  static int Nt() { return m_Nt; }
  static int Nvol() { return m_Nvol; }

  static int Nc() { return m_Nc; }
  static int Nd() { return m_Nd; }
  static int Ndim() { return m_Ndim; }

  static double epsilon_criterion() { return m_epsilon_criterion; }
  static double epsilon_criterion2() { return pow(m_epsilon_criterion, 2); }

  static Bridge::VerboseLevel Vlevel() { return m_vlevel; }
};
#endif
