/*!
        @file    $Id:: parameterManager.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
 */

#ifndef PARAMETERMANAGER_INCLUDED
#define PARAMETERMANAGER_INCLUDED

#include "configure.h"
#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"

//! Base class of parameter manager.

/*!
                          [17 Jun 2012 H.Matsufuru]
 */

class ParameterManager
{
 protected:

  Bridge::VerboseLevel m_vl;

 public:

  ParameterManager() : m_vl(CommonParameters::Vlevel()) {}

  virtual ~ParameterManager() {}

  virtual void
  read_params(const std::string& params_file, Parameters *params) = 0;
};
#endif
