/*!
        @file    $Id:: parameterManager_YAML.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
 */

#ifndef PARAMETERMANAGER_YAML_INCLUDED
#define PARAMETERMANAGER_YAML_INCLUDED

#include "parameterManager.h"

#include <string>
#include <valarray>
#include <iostream>

//! Parameter manager with YAML parser.

/*!
   This is a simple parser to read parameters from a file
   prepared with YAML format.
   Only simple cases were checked.
                                      [17 Jul 2012 H.Matsufuru]
 */
class ParameterManager_YAML : public ParameterManager
{
 public:

  ParameterManager_YAML() {}

  //! read parameters from file.
  void read_params(const std::string& params_file, Parameters *params);

  //! read parameters from input file stream.
  void read_params(std::istream&, Parameters *params);

 private:

  //! extract key and value from a given line.
  int set_key_and_value(std::string& keystr, std::string& valstr, std::string& line);

  //! remove spaces from both side of a string.
  int remove_space(std::string&);

  //! convert from string to int vector.
  void convert_int_vector(std::valarray<int>& vec, std::string& valstr);

  //! convert from string to double vector.
  void convert_double_vector(std::valarray<double>& vec, std::string& valstr);
};
#endif
