/*!
        @file    $Id:: parameters_fa#$

        @brief

        @author  $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$

        @version $LastChangedRevision: 936 $
*/

#include "parameters_factory.h"
using Bridge::vout;

ParametersFactory& ParametersFactory::Instance()
{
  if (!s_instance) {
    //
    // acquire lock here
    //
    if (!s_instance) {
      CreateInstance();
    }
    //
    // release lock here
    //
  }

  return *s_instance;
}


void ParametersFactory::CreateInstance()
{
  static ParametersFactory instance_;

  s_instance = &instance_;
}


Parameters *ParametersFactory::create_parameters(const std::string& realm)
{
  database_type::const_iterator q = m_map.find(realm);

  if (q == m_map.end()) {
    vout.crucial("%s: key \'%s\' not found.\n", __func__, realm.c_str());
    return 0;
  }

  creator_callback_list cl = q->second;

  Parameters *param = new Parameters;
  for (creator_callback_list::const_iterator p = cl.begin(); p != cl.end(); ++p) {
    (*p)(*param);
  }

  return param;
}


bool ParametersFactory::register_callback(const std::string& realm, const creator_callback& cb)
{
  std::vector<std::string> v = string_tokenize(realm, '.');

  while (v.size() > 0)
  {
    std::string subrealm = string_concat(v, '.');

#if 0
    // for debug: use stdio because vout is not ready at this stage.
    printf("%s: append to %s\n", __func__, subrealm.c_str());
    printf("%s: realm \'%s\": callback append to %s\n", __func__, realm.c_str(), subrealm.c_str());
#endif

    m_map[subrealm].push_back(cb);

    v.pop_back();
  }

  return true;
}


std::vector<std::string> ParametersFactory::string_tokenize(const std::string& src, const char delim)
{
  std::vector<std::string> retv;

  size_t npos = src.length();
  size_t p    = 0;

  while (true)
  {
    size_t q = src.find(delim, p);

    if (q >= npos) {                 // not found
      retv.push_back(src.substr(p)); // append rest
      break;
    }

    retv.push_back(src.substr(p, q - p));
    p = q + 1;  // skip delimiter.
  }

  return retv;
}


std::string ParametersFactory::string_concat(const std::vector<std::string>& src, const char delim)
{
  if (src.size() == 0) return std::string();

  std::string buf = src[0];
  for (size_t i = 1; i < src.size(); ++i) {
    buf += delim;
    buf += src[i];
  }

  return buf;
}


ParametersFactory *ParametersFactory::s_instance = 0;
