/*!
        @file    $Id:: projection_Stout_SU3.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef PROJECTION_STOUT_SU3_INCLUDED
#define PROJECTION_STOUT_SU3_INCLUDED

#include <cassert>
#include <valarray>
#include "projection.h"
#include "bridge_complex.h"
#include "mat_SU_N.h"
//#include "libkek.h"  //- only for BG/Q

#include "bridgeIO.h"
using Bridge::vout;

// The following implementation only valid for Nc = 3 case.
#define  NC    3


//! Stout(exponential)-type projection to SU(N) gauge group.

/*!
    Present implpementation applies to SU(3) case only, since
    the SU(3) properties are explicitly used.
                                    [08 Apr 2012 H.Matsufuru]
 */

//- parameters class
class Parameters_Projection_Stout_SU3 : virtual public Parameters
{
 public:
  Parameters_Projection_Stout_SU3();
};
//-

class Projection_Stout_SU3 : public Projection
{
 private:
  unsigned long int m_flop;
  double            m_time;

 public:

  Projection_Stout_SU3()
  {
    setup();
  }

  ~Projection_Stout_SU3() {}

  void set_parameters(const Parameters& param);

  //! projection U = P[alpha, C, Uorg]
  void project(Field_G& U,
               double alpha,
               const Field_G& C, const Field_G& Uorg);

  //! determination of fields for force calculation
  void force_recursive(Field_G& Xi, Field_G& iTheta,
                       double alpha, const Field_G& Sigmap,
                       const Field_G& C, const Field_G& U);

  void print_stat();

 private:
  void exp_iQ(Field_G& e_iQ, const Field_G& iQ);
  void exp_iQ_bf(Field_G& e_iQ, const Field_G& iQ);

  void set_uw(double& u, double& w,
              const Mat_SU_N& iQ1, const Mat_SU_N& iQ2);

  void set_fj(dcomplex& f0, dcomplex& f1, dcomplex& f2,
              const double& u, const double& w);

  double func_xi0(double w);
  double func_xi1(double w);

  void setup();
};
#endif
