/*!
        @file    $Id:: smear.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef SMEAR_INCLUDED
#define SMEAR_INCLUDED

#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "field_G.h"
#include "projection.h"
#include "bridgeIO.h"

#ifdef USE_FACTORY
#include "factory.h"
#endif


//! base class for smearing of link variables.

/*!
                            [28 Dec 2011 H.Matsufuru]
 */

class Smear
{
 protected:
  Bridge::VerboseLevel m_vl;

 public:
  Smear()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~Smear() {}

  virtual void smear(Field_G&, const Field_G&) = 0;

  virtual void set_parameters(const Parameters&) = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

#ifdef USE_FACTORY
 public:
  typedef Smear *(*ProductCreator)(Projection *);
  typedef FactoryTemplate<Smear, ProductCreator>   Factory;

  static Smear *New(const IdentifierType& subtype, Projection *proj)
  {
    ProductCreator p = Factory::Find(subtype);

    return p ? (*p)(proj) : 0;
  }
#endif
};
#endif
