/*!
        @file    $Id:: smear_APE_SF.h #$

        @brief

        @author  <Yusuke Taniguchi> tanigchi@het.ph.tsukuba.ac.jp
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef SMEAR_APE_SF_INCLUDED
#define SMEAR_APE_SF_INCLUDED

#include "smear.h"
#include "staples_SF.h"

#include "bridgeIO.h"
using Bridge::vout;

//! APE type smearing of link variables.

/*!
    This class is alternative to the Smear_APE class.
                            [08 Apr 2012 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.    [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Smear_APE_SF : virtual public Parameters
{
 public:
  Parameters_Smear_APE_SF();
};
//- end

class Smear_APE_SF : public Smear
{
 private:
  int m_Ndim;
  std::valarray<double> m_rho;
  Projection            *m_proj;

  //! SF boundary condition at t=0
  double m_phi[3];
  //! SF boundary condition at t=Nt
  double m_phipr[3];

 public:
  Smear_APE_SF(Projection *proj)
    : Smear(),
      m_Ndim(CommonParameters::Ndim()), m_rho(0.0, m_Ndim * m_Ndim),
      m_proj(proj) {}

  ~Smear_APE_SF() {}

  void set_parameters(const Parameters& params);
  void set_parameters(const double rho1, double *phi, double *phipr);
  void set_parameters(const std::valarray<double>& rho, double *phi, double *phipr);

  void smear(Field_G& Usmear, const Field_G& U);

  //  void staple(Field_G&, const Field_G&, const Field_G&,
  //              int mu, int nu);
};
#endif
