/*!
        @file    $Id:: shiftsolver.h 943#$

        @brief

        @author  $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-22 16:55:30 #$

        @version $LastChangedRevision: 943 $
*/

#ifndef SHIFTSOLVER_INCLUDED
#define SHIFTSOLVER_INCLUDED

#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "bridgeIO.h"
#include "field.h"
#include "fopr.h"
#include <valarray>

//! Shiftsolver class as an abstract base class for multi-shift solvers.

class Shiftsolver
{
 public:

  Shiftsolver()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~Shiftsolver() {}

  virtual void set_parameters(const Parameters&) = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual void solve(
    std::valarray<Field>& solution,
    std::valarray<double> shift,
    const Field& source,
    int& Nconv, double& diff) = 0;

 protected:

  Bridge::VerboseLevel m_vl;
};
#endif
