/*!
        @file    $Id:: shiftsolver_CG.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef SHIFTSOLVER_CG_INCLUDED
#define SHIFTSOLVER_CG_INCLUDED

#include "shiftsolver.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Shiftsolver_CG : virtual public Parameters
{
 public:
  Parameters_Shiftsolver_CG();
};
//- end

//! Multishift Conjugate Gradient solver.

/*!
                                    [23 Dec 2011  H.Matsufuru]
 */

class Shiftsolver_CG : public Shiftsolver
{
 private:

  Fopr   *m_fopr;
  int    m_Niter;
  double m_Stop_cond;

  std::valarray<Field>  x, p;
  Field                 r, s;
  std::valarray<double> zeta1, zeta2, csh2, pp;
  double                snorm, alpha_p, beta_p;
  int Nshift2;

 public:

  Shiftsolver_CG(Fopr *fopr)
    : Shiftsolver(), m_fopr(fopr) {}

  Shiftsolver_CG(Fopr *fopr, int niter, double stop_cond)
    : Shiftsolver(), m_fopr(fopr)
  {
    set_parameters(niter, stop_cond);
  }

  ~Shiftsolver_CG() {}

  void set_parameters(const Parameters& params);
  void set_parameters(const int niter, const double stop_cond);

  void solve(
    std::valarray<Field>& solution,
    std::valarray<double> shift,
    const Field& source,
    int& Nconv, double& diff);

 private:

  void solve_init(double&);
  void solve_step(double&, const std::valarray<double>&);
};
#endif
