/*!
        @file    $Id:: solver.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef SOLVER_INCLUDED
#define SOLVER_INCLUDED

#include "defs.h"
#include "parameters.h"
#include "commonParameters.h"
#include "bridgeIO.h"

#include "fopr.h"
#include "field.h"

#ifdef USE_FACTORY
#include "factory.h"
#endif


//! Base class for linear solver class family.

/*!
                               [28 Dec 2011 H.Matsufuru]
 */

class Solver
{
 public:

  Solver()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~Solver() {}

  virtual void set_parameters(const Parameters& params) = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual void set_parameters(const int Niter, const double Stop_cond) = 0;

  virtual void solve(Field& solution, const Field& source,
                     int& Nconv, double& diff) = 0;

  virtual Fopr *get_fopr() = 0;

 protected:

  Bridge::VerboseLevel m_vl;

#ifdef USE_FACTORY
 public:
  typedef Solver *(*ProductCreator)(Fopr *);
  typedef FactoryTemplate<Solver, ProductCreator>   Factory;

  static Solver *New(const IdentifierType& subtype, Fopr *fopr)
  {
    ProductCreator p = Factory::Find(subtype);

    return p ? (*p)(fopr) : 0;
  }
#endif
};
#endif
