/*!
        @file    $Id:: solver_BiCGStab.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$

        @version $LastChangedRevision: 936 $
*/

#ifndef SOLVER_BICGSTAB_INCLUDED
#define SOLVER_BICGSTAB_INCLUDED

#include "solver.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Solver_BiCGStab : virtual public Parameters
{
 public:
  Parameters_Solver_BiCGStab();
};
//- end

//! BiCGStab algorithm.

/*!
    This class implements BiCGStab algorithm for nonhermitian
    matrix.
    The matrix is just nonsymmetric matrix, and the product of
    vectors is treated in not complex but real.
                                   [22 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.           [14 Nov 2012 Y.Namekawa]
 */

class Solver_BiCGStab : public Solver
{
 private:
  Fopr   *m_fopr;
  int    m_Niter;
  double m_Stop_cond;

  Field  s, r, x, rh, p, v;
  double rho_p, alpha_p, omega_p;

 public:
  Solver_BiCGStab(Fopr *fopr)
    : Solver(), m_fopr(fopr) {}

  ~Solver_BiCGStab() {}

  void set_parameters(const Parameters& params);
  void set_parameters(const int Niter, const double Stop_cond);

  void solve(Field& solution, const Field& source,
             int& Nconv, double& diff);

  Fopr *get_fopr() { return m_fopr; }

 private:
  void reset_field(const Field&);

  void solve_init(const Field&, double&);
  void solve_step(double&);
};
#endif
