/*!
        @file    $Id:: solver_BiCGStab_Cmplx.h #$

        @brief

        @author  <Yusuke Namekawa> namekawa@ccs.tsukuba.ac.jp(namekawa)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$

        @version $LastChangedRevision: 936 $
*/

#ifndef SOLVER_BICGSTAB_CMPLX_INCLUDED
#define SOLVER_BICGSTAB_CMPLX_INCLUDED

#include "solver.h"
#include "bridge_complex.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Solver_BiCGStab_Cmplx : virtual public Parameters
{
 public:
  Parameters_Solver_BiCGStab_Cmplx();
};
//- end

//! BiCGStab algorithm with complex variables.

/*!
   This class implements BiCGStab algorithm for nonhermitian
   matrix.
   The matrix is nonsymmetric matrix, and the product of
   vectors is treated in complex.
                                   [12 Feb 2012 Y.Namekawa]
    (Coding history will be recovered from trac.)
    YAML is implemented.           [14 Nov 2012 Y.Namekawa]
 */

class Solver_BiCGStab_Cmplx : public Solver
{
 private:
  Fopr   *m_fopr;
  int    m_Niter;
  double m_Stop_cond;

  Field    s, r, x, rh, p, v, w;
  dcomplex rho_p, alpha_p, omega_p;

 public:
  Solver_BiCGStab_Cmplx(Fopr *fopr)
    : Solver(), m_fopr(fopr) {}

  ~Solver_BiCGStab_Cmplx() {}

  void set_parameters(const Parameters& params);
  void set_parameters(const int Niter, const double Stop_cond);

  void solve(Field& solution, const Field& source,
             int& Nconv, double& diff);

  Fopr *get_fopr() { return m_fopr; }

 private:
  void reset_field(const Field&);

  void solve_init(const Field&, double&);
  void solve_step(double&);

  void innerprod_c(double& prod_r, double& prod_i,
                   const Field& v, const Field& w);

  void mult_c(Field& v,
              const Field& w,
              const double& prod_r, const double& prod_i);
};
#endif
