/*!
        @file    $Id:: solver_BiCGStab_IDS_L_Cmplx.h #$

        @brief

        @author  <Yusuke Namekawa> namekawa@ccs.tsukuba.ac.jp(namekawa)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$

        @version $LastChangedRevision: 936 $
*/

#ifndef SOLVER_BICGSTAB_IDS_L_CMPLX_INCLUDED
#define SOLVER_BICGSTAB_IDS_L_CMPLX_INCLUDED

#include "solver.h"
#include "bridge_complex.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Solver_BiCGStab_IDS_L_Cmplx : virtual public Parameters
{
 public:
  Parameters_Solver_BiCGStab_IDS_L_Cmplx();
};
//- end

//! BiCGStab(IDS_L) algorithm.

/*!
    This class implements BiCGStab(IDS_L) algorithm for nonhermitian
    matrix.
    The matrix is just nonsymmetric matrix, and the product of
    vectors is treated in complex.
    See S.Itoh and Y.Namekawa, J.Comp.Appl.Math. 159 (2003) 65.
                                   [22 Jan 2012 Y.Namekawa]
    (Coding history will be recovered from trac.)
    YAML is implemented.           [14 Nov 2012 Y.Namekawa]
 */

class Solver_BiCGStab_IDS_L_Cmplx : public Solver
{
 private:
  Fopr *m_fopr;

  int    m_N_L;
  double m_Tol_L;

  int    m_Niter;
  double m_Stop_cond;

  std::valarray<Field> u, r;

  Field s, x, r_init, v_tmp;

  dcomplex rho_p, alpha_p, omega_p;
  int      N_L_p;

 public:
  Solver_BiCGStab_IDS_L_Cmplx(Fopr *fopr)
    : Solver(), m_fopr(fopr) {}

  ~Solver_BiCGStab_IDS_L_Cmplx() {}

  void set_parameters(const Parameters& params);

  void set_parameters(const int Niter, const double Stop_cond);
  void set_parameters_DS_L(const int N_L, const double Tol_L);

  void solve(Field& solution, const Field& source,
             int& Nconv, double& diff);

  Fopr *get_fopr() { return m_fopr; }

 private:
  void reset_field(const Field&);

  void solve_init(const Field&, double&);
  void solve_step(double&);

  void innerprod_c(double& prod_r, double& prod_i,
                   const Field& v, const Field& w);

  void mult_c(Field& v,
              const Field& w,
              const double& prod_r, const double& prod_i);

  int index_ij(int i, int j)
  {
    return i + m_N_L * j;
  }
};
#endif
