/*!
        @file    $Id:: solver_CG.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef SOLVER_CG_INCLUDED
#define SOLVER_CG_INCLUDED

#include "solver.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Solver_CG : virtual public Parameters
{
 public:
  Parameters_Solver_CG();
};
//- end

//! Standard Conjugate Gradient solver algorithm.

/*!
    This solver class implements the standard Conjugate Gradient
    solver algorithm.
                                   [22 Dec H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.           [14 Nov 2012 Y.Namekawa]
 */

class Solver_CG : public Solver
{
 private:
  Fopr   *m_fopr;
  int    m_Niter;
  double m_Stop_cond;

  Field s, r, x, p, v;

 public:
  Solver_CG(Fopr *fopr)
    : Solver(), m_fopr(fopr) {}

  ~Solver_CG() {}

  void set_parameters(const Parameters& params);
  void set_parameters(const int Niter, const double Stop_cond);

  void solve(Field& solution, const Field& source,
             int& Nconv, double& diff);

  Fopr *get_fopr() { return m_fopr; }

 private:
  void reset_field(const Field&);

  void solve_init(const Field&, double&);
  void solve_step(double&);
};
#endif
