/*!
        @file    $Id: solver_CGNR.cpp #$

        @brief

        @author
                 $LastChangedBy: sueda $

        @date    $LastChangedDate: 2013-04-27 12:28:50 #$

        @version $LastChangedRevision: 930 $
*/


#include "solver_CGNR.h"
using Bridge::vout;

#ifdef USE_PARAMETERS_FACTORY
#include "parameters_factory.h"
#endif

#ifdef USE_FACTORY
namespace {
  Solver *create_object(Fopr *fopr)
  {
    return new Solver_CGNR(fopr);
  }


  bool init = Solver::Factory::Register("CGNR", create_object);
}
#endif

//- parameter entries
namespace {
  void append_entry(Parameters& param)
  {
    param.Register_int("maximum_number_of_iteration", 0);
    param.Register_double("convergence_criterion_squared", 0.0);

    param.Register_string("verbose_level", "NULL");
  }


#ifdef USE_PARAMETERS_FACTORY
  bool init_param = ParametersFactory::Register("Solver.CGNR", append_entry);
#endif
}
//- end

//- parameters class
Parameters_Solver_CGNR::Parameters_Solver_CGNR() { append_entry(*this); }
//- end

//====================================================================
void Solver_CGNR::set_parameters(const Parameters& params)
{
  return this->Solver_CG::set_parameters(params);
}


//====================================================================
void Solver_CGNR::solve(Field& xq, const Field& b, int& Nconv, double& diff)
{
  vout.detailed(m_vl, "  CGNR solver starts\n");

  Fopr *fopr = this->Solver_CG::get_fopr();

  string prev_mode = fopr->get_mode();

  if (prev_mode == "DdagD") {
    this->Solver_CG::solve(xq, b, Nconv, diff);  // fallback to CG solver
    return;
  }

  if (!((prev_mode == "D") || (prev_mode == "Ddag"))) {
    vout.crucial(m_vl, "Solver_CGNR: unsupported mode for fopr: %s.", prev_mode.c_str());
    abort();
  }

  Field b2(b);
  fopr->mult_dag(b2, b);

  if (prev_mode == "D") {
    fopr->set_mode("DdagD");
  } else if (prev_mode == "Ddag") {
    fopr->set_mode("DDdag");
  }

  this->Solver_CG::solve(xq, b2, Nconv, diff);

  fopr->set_mode(prev_mode);
}


//====================================================================
//============================================================END=====
