/*!
        @file    $Id:: solver_GMRES_m_Cmplx.h #$

        @brief

        @author  <Yusuke Namekawa> namekawa@ccs.tsukuba.ac.jp(namekawa)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$

        @version $LastChangedRevision: 936 $
*/

#ifndef SOLVER_GMRES_m_CMPLX_INCLUDED
#define SOLVER_GMRES_m_CMPLX_INCLUDED

#include "solver.h"
#include "bridge_complex.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
class Parameters_Solver_GMRES_m_Cmplx : virtual public Parameters
{
 public:
  Parameters_Solver_GMRES_m_Cmplx();
};
//- end

//! GMRES(m) algorithm with complex variables.

/*!
   This class implements GMRES(m) algorithm for nonhermitian
   matrix.
   The matrix is nonsymmetric matrix, and the product of
   vectors is treated in complex.
   See Y.Saad and M.H.Schultz, SIAM J.Sci.Stat.Comput. 7 (1986) 856.
                                   [8 Aug 2012  Y.Namekawa]
    (Coding history will be recovered from trac.)
    YAML is implemented.           [14 Nov 2012 Y.Namekawa]
 */

class Solver_GMRES_m_Cmplx : public Solver
{
 private:

  Fopr   *m_fopr;
  int    m_Niter;
  double m_Stop_cond;

  int m_N_M;

  std::valarray<Field> v;

  Field  s, r, x, v_tmp;
  double beta_p;

 public:

  Solver_GMRES_m_Cmplx(Fopr *fopr)
    : Solver(), m_fopr(fopr) {}

  ~Solver_GMRES_m_Cmplx() {}

  void set_parameters(const Parameters& params);

  void set_parameters(const int Niter, const double Stop_cond);
  void set_parameters_GMRES_m(const int N_M);

  void solve(Field& solution, const Field& source,
             int& Nconv, double& diff);

  Fopr *get_fopr() { return m_fopr; }

 private:

  void reset_field(const Field&);

  void solve_init(const Field&, double&);
  void solve_step(const Field&, double&);

  void innerprod_c(double& prod_r, double& prod_i,
                   const Field& v, const Field& w);

  void min_J(std::valarray<dcomplex>& y,
             std::valarray<dcomplex>& h);

  void mult_c(Field& v,
              const Field& w,
              const double& prod_r, const double& prod_i);

  int index_ij(int i, int j)
  {
    return i + (m_N_M + 1) * j;
  }
};
#endif
