/*!
        @file    $Id: test_Gauge_Shift.cpp #$

        @brief

        @author  Hideo Matsufuru <hideo.matsufuru@kek.jp> (matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate: 2013-01-22 13:51:53 #$

        @version $LastChangedRevision: 936 $
*/

#include "parameterManager_YAML.h"

#include "bridgeIO.h"
using Bridge::vout;

#include "index_lex.h"
// #include "index_eo.h"

#include "gaugeConfig.h"
#include "staples.h"

#include "shiftField_lex.h"

#ifdef USE_TEST
#include "test.h"
#endif

#ifdef USE_TESTMANAGER_AUTOREGISTER
#include "testManager.h"
#endif

//====================================================================
//! Test of gauge quantities.

/*!
                          [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.  [14 Nov 2012 Y.Namekawa]
 */

namespace Test_Gauge {
  //- test-private parameters
  namespace {
    const std::string filename_input  = "test_Gauge.yaml";
    const std::string filename_output = "stdout";

    class Parameters_Test_Gauge : public Parameters {
     public:
      Parameters_Test_Gauge()
      {
        Register_string("gauge_config_type_input", "NULL");
        Register_string("config_filename_input", "NULL");

        Register_string("verbose_level", "NULL");

        Register_double("expected_result", 0.0);
      }
    };
  }

  //- prototype declaration
  int shift(void);

#ifdef USE_TESTMANAGER_AUTOREGISTER
  namespace {
    static const bool is_registered = TestManager::RegisterTest(
      "Gauge.Shift",
      shift
      );
  }
#endif

  //====================================================================
  int shift(void)
  {
    // #####  parameter setup  #####
    int Nvol = CommonParameters::Nvol();
    int Ndim = CommonParameters::Ndim();

    Parameters_Test_Gauge params_test;

    Parameters params_all;

    params_all.Register_Parameters("Test_Gauge", &params_test);

    ParameterManager_YAML params_manager;
    params_manager.read_params(filename_input, &params_all);

    const string str_gconf_read = params_test.get_string("gauge_config_type_input");
    const string readfile       = params_test.get_string("config_filename_input");
    const string str_vlevel     = params_test.get_string("verbose_level");
#ifdef USE_TEST
    const double expected_result = params_test.get_double("expected_result");
#endif

    Bridge::VerboseLevel vl = vout.set_verbose_level(str_vlevel);

    //- print input parameters
    vout.general(vl, "  gconf_read = %s\n", str_gconf_read.c_str());
    vout.general(vl, "  readfile   = %s\n", readfile.c_str());
    vout.general(vl, "  vlevel     = %s\n", str_vlevel.c_str());
    vout.general(vl, "\n");

    //- input parameter check
    int err = 0;
    err += ParameterCheck::non_NULL(str_gconf_read);
    err += ParameterCheck::non_NULL(readfile);

    if (err) {
      vout.crucial(vl, "Test_Gauge: Input parameters have not been set.\n");
      abort();
    }


    // #### object setup #####
    Field_G     *U          = new Field_G(Nvol, Ndim);
    GaugeConfig *gconf_read = new GaugeConfig(str_gconf_read);
    gconf_read->read_file((Field *)U, readfile);
    // gconf_read->set_cold((Field*)U);

    Index_lex      *index = new Index_lex;
    ShiftField_lex shift;

    Field_G *U2     = new Field_G(Nvol, Ndim);
    Staples *staple = new Staples;


    // ####  Execution main part  ####
    shift.backward(*U2, *U, 3);
    vout.general(vl, "U  = %.8f\n", U->cmp(17, index->site(0, 0, 0, 0), 2));
    vout.general(vl, "U2 = %.8f\n", U2->cmp(17, index->site(0, 0, 0, 7), 2));
    vout.general(vl, "\n");

    shift.forward(*U2, *U, 0);
    vout.general(vl, "U  = %.8f\n", U->cmp(17, index->site(0, 0, 0, 0), 3));
    vout.general(vl, "U2 = %.8f\n", U2->cmp(17, index->site(1, 0, 0, 0), 3));
    vout.general(vl, "\n");

    double result;
    int    nodeid = Communicator::nodeid();

    result = staple->plaquette(*U);
    vout.general(vl, "plaq (original field) = %d  %.8f\n", nodeid, result);

    result = staple->plaquette(*U2);
    vout.general(vl, "plaq (shifted field)  = %d  %.8f\n", nodeid, result);


    // ####  tydy up  ####
    delete U;
    delete U2;
    delete gconf_read;

    delete staple; // added by s.motoki[12/06/05].
    delete index;  // added by s.motoki[12/06/05].


#ifdef USE_TEST
    return Test::verify(expected_result, result);

#else
    return EXIT_SUCCESS;
#endif
  }
} // namespace Test_Gauge
